<?php
// public/personnel/edit.php
declare(strict_types=1);
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/layout.php';
require_once __DIR__ . '/../../includes/flash.php';

require_role('admin','hr');
global $pdo;

// Get ID and fetch record
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    set_flash('danger', 'Invalid personnel ID.');
    header('Location: /ldp/public/personnel/index.php');
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM personnel WHERE id = ?");
$stmt->execute([$id]);
$person = $stmt->fetch();

if (!$person) {
    set_flash('danger', 'Personnel record not found.');
    header('Location: /ldp/public/personnel/index.php');
    exit;
}

$errors = [];
// Pre-fill with existing values
$employee_id   = $person['employee_id'] ?? '';
$name          = $person['name'] ?? '';
$position      = $person['position'] ?? '';
$employee_type = $person['employee_type'] ?? '';
$status        = $person['status'] ?? '';
$title         = $person['title'] ?? '';
$title_ld      = $person['title_ld'] ?? '';
$date_from     = $person['date_from'] ?? '';
$date_to       = $person['date_to'] ?? '';
$type          = $person['type'] ?? '';
$level         = $person['level'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    $employee_id   = trim($_POST['employee_id'] ?? '');
    $name          = trim($_POST['name'] ?? '');
    $position      = trim($_POST['position'] ?? '');
    $employee_type = trim($_POST['employee_type'] ?? '');
    $status        = trim($_POST['status'] ?? '');
    $title         = trim($_POST['title'] ?? '');
    $title_ld      = trim($_POST['title_ld'] ?? '');
    $date_from     = trim($_POST['date_from'] ?? '');
    $date_to       = trim($_POST['date_to'] ?? '');
    $type          = trim($_POST['type'] ?? '');
    $level         = trim($_POST['level'] ?? '');

    if ($employee_id === '') $errors['employee_id'] = 'Employee ID is required.';
    if ($name === '') $errors['name'] = 'Name is required.';
    if ($position === '') $errors['position'] = 'Position is required.';

    if (empty($errors)) {
        $stmt = $pdo->prepare("UPDATE personnel SET
            employee_id=?, name=?, position=?, employee_type=?, status=?,
            title=?, title_ld=?, date_from=?, date_to=?, type=?, level=?
            WHERE id=?");
        $stmt->execute([
            $employee_id, $name, $position, $employee_type, $status,
            $title, $title_ld, $date_from, $date_to, $type, $level,
            $id
        ]);

        set_flash('success', 'Personnel record updated.');
        header('Location: /ldp/public/personnel/index.php');
        exit;
    }
}

render_header('Edit Personnel', 'personnel');
?>

<div class="card">
  <div class="card-body">
    <form method="post" autocomplete="off" novalidate>
      <?= csrf_field(); ?>

      <div class="form-row">
        <div class="form-group col-md-4">
          <label class="form-required">Employee ID</label>
          <input name="employee_id" class="form-control <?= isset($errors['employee_id'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($employee_id) ?>">
          <?php if(isset($errors['employee_id'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['employee_id']) ?></div><?php endif; ?>
        </div>
        <div class="form-group col-md-8">
          <label class="form-required">Full Name</label>
          <input name="name" class="form-control <?= isset($errors['name'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($name) ?>">
          <?php if(isset($errors['name'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['name']) ?></div><?php endif; ?>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group col-md-6">
          <label class="form-required">Position</label>
          <input name="position" class="form-control <?= isset($errors['position'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($position) ?>">
          <?php if(isset($errors['position'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['position']) ?></div><?php endif; ?>
        </div>
        <div class="form-group col-md-6">
          <label>Employee Type</label>
          <select name="employee_type" class="form-control">
            <option value="">— Select Type —</option>
            <option value="Faculty" <?= $employee_type==='Faculty'?'selected':'' ?>>Faculty</option>
            <option value="Non-Teaching" <?= $employee_type==='Non-Teaching'?'selected':'' ?>>Non-Teaching</option>
          </select>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group col-md-6">
          <label>Status</label>
          <select name="status" class="form-control">
            <option value="">— Select Status —</option>
            <option value="Permanent" <?= $status==='Permanent'?'selected':'' ?>>Permanent</option>
            <option value="Contract of Services (COS)" <?= $status==='Contract of Services (COS)'?'selected':'' ?>>Contract of Services (COS)</option>
            <option value="Job Order (JO)" <?= $status==='Job Order (JO)'?'selected':'' ?>>Job Order (JO)</option>
          </select>
        </div>
        <div class="form-group col-md-6">
          <label>Title</label>
          <input name="title" class="form-control" value="<?= htmlspecialchars($title) ?>">
        </div>
      </div>

      <div class="form-group">
        <label>Title of L&D</label>
        <input name="title_ld" class="form-control" value="<?= htmlspecialchars($title_ld) ?>">
      </div>

      <div class="form-row">
        <div class="form-group col-md-3">
          <label>Date From</label>
          <input type="date" name="date_from" class="form-control" value="<?= htmlspecialchars($date_from) ?>">
        </div>
        <div class="form-group col-md-3">
          <label>Date To</label>
          <input type="date" name="date_to" class="form-control" value="<?= htmlspecialchars($date_to) ?>">
        </div>
        <div class="form-group col-md-3">
          <label>Type</label>
          <select name="type" class="form-control">
            <option value="">— Select Type —</option>
            <option value="Local" <?= $type==='Local'?'selected':'' ?>>Local</option>
            <option value="National" <?= $type==='National'?'selected':'' ?>>National</option>
            <option value="Regional" <?= $type==='Regional'?'selected':'' ?>>Regional</option>
          </select>
        </div>
        <div class="form-group col-md-3">
          <label>Level</label>
          <input name="level" class="form-control" value="<?= htmlspecialchars($level) ?>">
        </div>
      </div>

      <div class="d-flex justify-content-between">
        <a href="/ldp/public/personnel/index.php" class="btn btn-outline-secondary"><i class="fas fa-arrow-left"></i> Back</a>
        <button class="btn btn-primary"><i class="fas fa-save"></i> Update</button>
      </div>
    </form>
  </div>
</div>

<?php render_footer(); ?>
